#include "config.h"
#include <gnome.h>
#include "gtkdial.h"

/* local declarations for properties box etc. */
void changed(GtkWidget *widget,GnomePropertyBox *propbox);
void help_show(GtkWidget *dialog,gint page,gpointer data);
void timerselect(void);
GtkWidget 	* single_bttn;
GtkWidget 	* quiet_bttn;
GtkWidget	* keep_choice;
GtkWidget	* timer_choice;
GtkWidget	* reset_choice;
GtkWidget	* save_choice;
GtkWidget	* total_choice;
GtkWidget	* mon_choice;
GtkWidget	* dialog;
GtkWidget	* gen_prefbox;
GtkWidget	* gen_label;
GtkWidget	* timer_prefbox;
GtkWidget	* timer_label;
GtkWidget	* exec_prefbox;
GtkWidget	* exec_label;
GtkWidget	* exec_info;
GtkWidget	* exec_txt;
GtkWidget	* limit_choice;
GtkWidget	* limit_hrs;
GtkWidget	* limit_reset_choice;
GtkWidget	* exec_entry;
GtkWidget	* buttonbox;
GtkObject	* limit_adj;
GtkWidget	* limit_label0;
GtkWidget	* limit_label1;
GtkWidget	* limit_hbox;
GtkWidget	* sep_1;
GtkWidget	* sep_2;

gboolean single_status, quiet_status, keep_status;
gboolean timer_status, reset_status, save_status;
gboolean mon_status, total_status, mon_changed;
gboolean limit_status, limit_reset_status;
long int limit_alert_value;
gchar *exec_status;			

static void mon_callback(GtkWidget *widget, GnomePropertyBox *propbox);
static void timercallback(GtkWidget *widget, GnomePropertyBox *propbox);

/* callback for changed prefs pages */
void changed(GtkWidget *widget, GnomePropertyBox *propbox) {
	gnome_property_box_changed(propbox);
}

/* special callback to limit access to timer options when the
 * timer is deselected */
void timerselect(void) {
	gboolean timer_t = get_state(timer_choice);
	gboolean save_t = get_state(save_choice);
	gboolean limit_t = get_state(limit_choice);
	gtk_widget_set_sensitive(GTK_WIDGET(reset_choice),timer_t);
	gtk_widget_set_sensitive(GTK_WIDGET(total_choice),save_t);
	gtk_widget_set_sensitive(GTK_WIDGET(limit_choice),save_t);
	gtk_widget_set_sensitive
		(GTK_WIDGET(limit_label0),limit_t && save_t);
	gtk_widget_set_sensitive
		(GTK_WIDGET(limit_label1),limit_t && save_t);
	gtk_widget_set_sensitive
		(GTK_WIDGET(limit_hrs),limit_t && save_t);
	gtk_widget_set_sensitive
		(GTK_WIDGET(limit_reset_choice),limit_t && save_t);
	if (! timer_t) {gtk_toggle_button_set_active
				(GTK_TOGGLE_BUTTON(reset_choice),0);
	}
	if (! save_t) { gtk_toggle_button_set_active
		                (GTK_TOGGLE_BUTTON(total_choice),0);
			gtk_toggle_button_set_active				                                (GTK_TOGGLE_BUTTON(limit_choice),0);
			gtk_toggle_button_set_active				                                (GTK_TOGGLE_BUTTON(limit_reset_choice),0);
	}
	gnome_config_sync();				
}

void mon_callback(GtkWidget *widget, GnomePropertyBox *propbox) {
	mon_changed=1;
	gnome_property_box_changed(propbox);
}

void timercallback(GtkWidget *widget, GnomePropertyBox *propbox) {
	timerselect();
	gnome_property_box_changed(propbox);
}

/* the main settings dialog box */
void settings_dlg(void) {
	dialog=gnome_property_box_new();

	/* get current config values */
	single_status=gnome_config_get_bool(SETTINGS_SINGLE);
	quiet_status=gnome_config_get_bool(SETTINGS_QUIET);
	keep_status=gnome_config_get_bool(SETTINGS_KEEP);
	reset_status=gnome_config_get_bool(SETTINGS_RESET);
	mon_status=gnome_config_get_bool(SETTINGS_MONITOR);
	timer_status=gnome_config_get_bool(SETTINGS_TIMER);
	save_status=gnome_config_get_bool(SETTINGS_SAVE);
	total_status=gnome_config_get_bool(SETTINGS_TOTAL);
	exec_status=gnome_config_get_string(SETTINGS_EXEC);
	limit_status=gnome_config_get_bool(SETTINGS_LIMIT);
	limit_reset_status=gnome_config_get_bool(SETTINGS_LIMIT_RESET);
	limit_alert_value=gnome_config_get_int(SETTINGS_LIMIT_VALUE);
	if (limit_alert_value<1) limit_alert_value=1;
        limit_adj=gtk_adjustment_new((gfloat)limit_alert_value,1,180,1,0,0);
	
	/* define widgets for prefbox pages */
	single_bttn=gtk_check_button_new_with_label
		(_("Start Gtkdial in single-service mode"));
	quiet_bttn=gtk_check_button_new_with_label
		(_("Disable audio connection alerts"));
	keep_choice = gtk_check_button_new_with_label
		(_("Close window after connect/disconnect"));
	mon_choice = gtk_check_button_new_with_label
		(_("Show connection debugging window"));
	timer_choice = gtk_check_button_new_with_label
		(_("Display session timer in main window"));
	reset_choice = gtk_check_button_new_with_label
		(_("Reset current session timer on each new connection"));
	save_choice = gtk_check_button_new_with_label
		(_("Save total time of all sessions"));
	total_choice = gtk_check_button_new_with_label
		(_("Display total timer in main window"));
	exec_txt = gtk_label_new(_("Execute after connection made:"));
	exec_info = gtk_label_new(_("The string entered below will be\n"
				"passed to the shell for execution in\n"
				"the background when a connection is\n"
				"successfully made."));
	exec_entry = gtk_entry_new();
	limit_choice = gtk_check_button_new_with_label
		(_("Alert me when total time reaches limit"));
	limit_label0 = gtk_label_new(_(" Alert after "));
	limit_label1 = gtk_label_new(_("hour(s)"));
	limit_hbox=gtk_hbox_new(0,0);
	limit_reset_choice = gtk_check_button_new_with_label
		(_("Reset total time when limit reached"));
	limit_hrs=gtk_spin_button_new(GTK_ADJUSTMENT(limit_adj),1,0);
	gtk_signal_connect(GTK_OBJECT(limit_hrs),"changed",
			GTK_SIGNAL_FUNC(changed),dialog);
	gtk_signal_connect(GTK_OBJECT(limit_reset_choice),"clicked",
			GTK_SIGNAL_FUNC(timercallback),dialog);
	

	/* Ensure window reflects current config */	
	gtk_toggle_button_set_active								(GTK_TOGGLE_BUTTON(single_bttn),single_status);
	gtk_toggle_button_set_active								(GTK_TOGGLE_BUTTON(quiet_bttn),quiet_status);
	gtk_toggle_button_set_active
		(GTK_TOGGLE_BUTTON(keep_choice),keep_status);
	gtk_toggle_button_set_active								(GTK_TOGGLE_BUTTON(timer_choice),timer_status);
	gtk_toggle_button_set_active								(GTK_TOGGLE_BUTTON(reset_choice),reset_status);
	gtk_toggle_button_set_active
		(GTK_TOGGLE_BUTTON(save_choice),save_status);
	gtk_toggle_button_set_active
		(GTK_TOGGLE_BUTTON(mon_choice),mon_status);
	gtk_toggle_button_set_active
		(GTK_TOGGLE_BUTTON(total_choice),total_status);
	gtk_toggle_button_set_active
		(GTK_TOGGLE_BUTTON(limit_choice),limit_status);
	gtk_toggle_button_set_active
		(GTK_TOGGLE_BUTTON(limit_reset_choice),limit_reset_status);
	gtk_entry_set_text(GTK_ENTRY(exec_entry),exec_status);

	
	/* Connect signals */	
	gtk_signal_connect(GTK_OBJECT(single_bttn),"clicked",changed,dialog);
	gtk_signal_connect(GTK_OBJECT(quiet_bttn),"clicked",changed,dialog);	
	gtk_signal_connect(GTK_OBJECT(keep_choice),"clicked",changed,dialog);
	gtk_signal_connect(GTK_OBJECT(total_choice),"clicked",changed,dialog);
	gtk_signal_connect
		(GTK_OBJECT(mon_choice),"clicked",mon_callback,dialog);
	gtk_signal_connect
		(GTK_OBJECT(timer_choice),"clicked",timercallback,dialog);
	gtk_signal_connect
		(GTK_OBJECT(save_choice),"clicked",timercallback,dialog);
	gtk_signal_connect
		(GTK_OBJECT(limit_choice),"clicked",timercallback,dialog);
	gtk_signal_connect(GTK_OBJECT(reset_choice),"clicked",changed,dialog);
	gtk_signal_connect(GTK_OBJECT(save_choice),"clicked",changed,dialog);
	gtk_signal_connect(GTK_OBJECT(exec_entry),"changed",changed,dialog);
	
	/* set initial state of timer page */
	timerselect();

	/* pack the box and display it */
	gen_prefbox=gtk_vbox_new(0,0);
	timer_prefbox=gtk_vbox_new(0,0);
	exec_prefbox=gtk_vbox_new(0,0);
	gen_label=gtk_label_new(_("General"));
	timer_label=gtk_label_new(_("Timer"));
	exec_label=gtk_label_new(_("Execute"));
	sep_1 = gtk_hseparator_new();
	sep_2 = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(gen_prefbox),single_bttn,1,1,1);
	gtk_box_pack_start(GTK_BOX(gen_prefbox),quiet_bttn,1,1,1);
	gtk_box_pack_start(GTK_BOX(gen_prefbox),keep_choice,1,1,1);
	gtk_box_pack_start(GTK_BOX(gen_prefbox),mon_choice,1,1,1);
	gtk_box_pack_start(GTK_BOX(timer_prefbox),timer_choice,1,1,1);
	gtk_box_pack_start(GTK_BOX(timer_prefbox),reset_choice,1,1,1);
	gtk_box_pack_start(GTK_BOX(timer_prefbox),sep_1,1,1,1);
	gtk_box_pack_start(GTK_BOX(timer_prefbox),save_choice,1,1,1);
	gtk_box_pack_start(GTK_BOX(timer_prefbox),total_choice,1,1,1);
	gtk_box_pack_start(GTK_BOX(timer_prefbox),sep_2,0,0,0);
	gtk_box_pack_start(GTK_BOX(timer_prefbox),limit_choice,1,1,1);
	gtk_box_pack_start(GTK_BOX(exec_prefbox),exec_info,1,1,1);
	gtk_box_pack_start(GTK_BOX(exec_prefbox),exec_txt,1,1,1);
	gtk_box_pack_start(GTK_BOX(exec_prefbox),exec_entry,1,1,1);
	gtk_box_pack_start(GTK_BOX(limit_hbox),limit_label0,0,0,1);
	gtk_box_pack_start(GTK_BOX(limit_hbox),limit_hrs,0,0,1);
	gtk_box_pack_start(GTK_BOX(limit_hbox),limit_label1,0,0,1);
	gtk_box_pack_start(GTK_BOX(timer_prefbox),limit_hbox,1,1,1);
	gtk_box_pack_start(GTK_BOX(timer_prefbox),limit_reset_choice,1,1,1);

	/* pack the pages, add a title, connect apply signal */
	gnome_property_box_append_page
		(GNOME_PROPERTY_BOX(dialog),gen_prefbox,gen_label);
	gnome_property_box_append_page
		(GNOME_PROPERTY_BOX(dialog),timer_prefbox,timer_label);
	gnome_property_box_append_page
		(GNOME_PROPERTY_BOX(dialog),exec_prefbox,exec_label);
	gtk_signal_connect(GTK_OBJECT(dialog),"apply",sync_settings,NULL);
	gtk_signal_connect(GTK_OBJECT(dialog),"help",help_show,NULL);
	gtk_window_set_title(GTK_WINDOW(dialog),_("GtkDial Settings"));
	gtk_window_set_modal(GTK_WINDOW(dialog),1);
	
	/* show the dialog */
	gtk_widget_show_all(dialog);
}

/* help button signal handler */
void help_show(GtkWidget *dialog,gint page,gpointer data) {
	GnomeHelpMenuEntry helpref[] = { { "gtkdial","prefs" } };
	gnome_help_pbox_display(NULL,page,helpref);
};

/* signal handler to apply changes */
void sync_settings(GtkWidget *dialog,gint page,gpointer data) {
	gnome_config_set_bool(SETTINGS_SINGLE,get_state(single_bttn));
	gnome_config_set_bool(SETTINGS_QUIET,get_state(quiet_bttn));
	gnome_config_set_bool(SETTINGS_KEEP,get_state(keep_choice));
	gnome_config_set_bool(SETTINGS_MONITOR,get_state(mon_choice));
	gnome_config_set_bool(SETTINGS_TIMER,get_state(timer_choice));
	gnome_config_set_bool(SETTINGS_RESET,get_state(reset_choice));
	gnome_config_set_bool(SETTINGS_SAVE,get_state(save_choice));
	gnome_config_set_bool(SETTINGS_TOTAL,get_state(total_choice));
	gnome_config_set_string(SETTINGS_EXEC,
			gtk_entry_get_text(GTK_ENTRY(exec_entry)));
	gnome_config_set_bool(SETTINGS_LIMIT,get_state(limit_choice));
	gnome_config_set_bool
		(SETTINGS_LIMIT_RESET,get_state(limit_reset_choice));
	gnome_config_set_int
		(SETTINGS_LIMIT_VALUE,
		 gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(limit_hrs)));
	quiet=get_state(quiet_bttn);
	kill_win=get_state(keep_choice);
	savetimer=get_state(save_choice);
	if (mon_changed) {
		if (get_state(mon_choice) && (!showmon)) open_monitor();
		else if ((!get_state(mon_choice)) && showmon) close_mon();
	};
	gnome_config_sync();
	post_exec = gnome_config_get_string(SETTINGS_EXEC);
	limit = gnome_config_get_bool(SETTINGS_LIMIT);
	limit_reset = gnome_config_get_bool(SETTINGS_LIMIT_RESET);
	limit_value = (gnome_config_get_int(SETTINGS_LIMIT_VALUE) * 3600);
}
